/*
 * Decompiled with CFR 0.152.
 */
package com.epam.indigo;

import com.sun.jna.Platform;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class IndigoUtils {
    public static String getPathToBinary(Class<?> cls, String dllpath, String path, String filename) throws FileNotFoundException {
        if (path == null) {
            String res = IndigoUtils.extractFromJar(cls, "/" + dllpath, filename);
            if (res != null) {
                return res;
            }
            throw new FileNotFoundException("Couldn't extract native lib " + filename + " (" + dllpath + ", " + path + ") from jar");
        }
        path = path + File.separator + dllpath + File.separator + filename;
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            return path;
        }
    }

    private static String extractFromJar(Class<?> cls, String path, String filename) {
        File dllfile;
        InputStream stream = cls.getResourceAsStream(path + "/" + filename);
        if (stream == null) {
            return null;
        }
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((len = stream.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            ByteArrayInputStream is1 = new ByteArrayInputStream(baos.toByteArray());
            ByteArrayInputStream is2 = new ByteArrayInputStream(baos.toByteArray());
            baos.close();
            String streamHashString = IndigoUtils.getHashString(is1);
            ((InputStream)is1).close();
            Path tmpdir_path = Paths.get(System.getProperty("java.io.tmpdir"), "indigo" + streamHashString);
            Files.createDirectories(tmpdir_path, new FileAttribute[0]);
            Path dllpath = Paths.get(tmpdir_path.toString(), filename);
            dllfile = dllpath.toFile();
            if (Files.notExists(dllpath, new LinkOption[0])) {
                FileOutputStream outstream = new FileOutputStream(dllfile);
                byte[] buf = new byte[4096];
                while ((len = is2.read(buf)) > 0) {
                    outstream.write(buf, 0, len);
                }
                outstream.close();
                ((InputStream)is2).close();
            }
        }
        catch (IOException | NoSuchAlgorithmException e) {
            return null;
        }
        try {
            return dllfile.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String getHashString(InputStream input) throws NoSuchAlgorithmException, IOException {
        byte[] hashArray;
        int nRead;
        StringBuilder res = new StringBuilder();
        MessageDigest algorithm = MessageDigest.getInstance("MD5");
        algorithm.reset();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        while ((nRead = input.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        algorithm.update(buffer.toByteArray());
        for (byte b : hashArray = algorithm.digest()) {
            String tmp = Integer.toHexString(0xFF & b);
            if (tmp.length() == 1) {
                res.append("0").append(tmp);
                continue;
            }
            res.append(tmp);
        }
        return res.toString();
    }

    static String getDllPath() {
        String path;
        if (Platform.isWindows()) {
            path = "windows-";
        } else if (Platform.isMac()) {
            path = "darwin-";
        } else if (Platform.isLinux()) {
            path = "linux-";
        } else {
            throw new Error("Operating system not recognized, only Linux, macOS and Windows are supported");
        }
        String os_arch = System.getProperty("os.arch");
        if (os_arch.equals("amd64") || os_arch.equals("x86_64") || os_arch.equals("x64")) {
            path = path + "x86_64";
        } else if (os_arch.equals("x86") || os_arch.equals("i386")) {
            path = path + "i386";
        } else if (os_arch.equals("aarch64") || os_arch.equals("arm64") || os_arch.equals("arm64e")) {
            path = path + "aarch64";
        } else {
            throw new Error(String.format("Machine architecture not supported: %s", os_arch));
        }
        return path;
    }
}

