/*
 * Decompiled with CFR 0.152.
 */
package com.epam.indigo;

import com.epam.indigo.IndigoException;
import com.epam.indigo.IndigoLib;
import com.epam.indigo.IndigoObject;
import com.epam.indigo.IndigoUtils;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.FloatByReference;
import com.sun.jna.ptr.IntByReference;
import java.io.FileNotFoundException;
import java.util.Collection;

public class Indigo {
    public static final int ABS = 1;
    public static final int OR = 2;
    public static final int AND = 3;
    public static final int EITHER = 4;
    public static final int UP = 5;
    public static final int DOWN = 6;
    public static final int CIS = 7;
    public static final int TRANS = 8;
    public static final int CHAIN = 9;
    public static final int RING = 10;
    public static final int ALLENE = 11;
    public static final int SINGLET = 101;
    public static final int DOUBLET = 102;
    public static final int TRIPLET = 103;
    public static final int RC_NOT_CENTER = -1;
    public static final int RC_UNMARKED = 0;
    public static final int RC_CENTER = 1;
    public static final int RC_UNCHANGED = 2;
    public static final int RC_MADE_OR_BROKEN = 4;
    public static final int RC_ORDER_CHANGED = 8;
    public static final int SG_TYPE_GEN = 0;
    public static final int SG_TYPE_DAT = 1;
    public static final int SG_TYPE_SUP = 2;
    public static final int SG_TYPE_SRU = 3;
    public static final int SG_TYPE_MUL = 4;
    public static final int SG_TYPE_MON = 5;
    public static final int SG_TYPE_MER = 6;
    public static final int SG_TYPE_COP = 7;
    public static final int SG_TYPE_CRO = 8;
    public static final int SG_TYPE_MOD = 9;
    public static final int SG_TYPE_GRA = 10;
    public static final int SG_TYPE_COM = 11;
    public static final int SG_TYPE_MIX = 12;
    public static final int SG_TYPE_FOR = 13;
    public static final int SG_TYPE_ANY = 14;
    public static final String INDIGO_DLL = "indigo.dll";
    public static final String LIBINDIGO_SO = "libindigo.so";
    public static final String LIBINDIGO_DYLIB = "libindigo.dylib";
    public static final String[] WIN_DLLS = new String[]{"vcruntime140.dll", "vcruntime140_1.dll", "msvcp140.dll"};
    private static final String dllpath;
    private static IndigoLib lib;
    private boolean session_released = false;
    private String path;
    private long sid;

    public Indigo(String path) {
        this.path = path;
        try {
            Indigo.loadIndigo(path);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
        System.setProperty("jna.encoding", "UTF-8");
        this.sid = lib.indigoAllocSessionId();
    }

    public Indigo() {
        this(null);
    }

    public static int checkResult(Object obj, int result) {
        if (result < 0) {
            throw new IndigoException(obj, lib.indigoGetLastError());
        }
        return result;
    }

    public static long checkResultLong(Object obj, long result) {
        if (result < 0L) {
            throw new IndigoException(obj, lib.indigoGetLastError());
        }
        return result;
    }

    public static int checkResult(Object obj, Object obj2, int result) {
        if (result < 0) {
            throw new IndigoException(new Object[]{obj, obj2}, lib.indigoGetLastError());
        }
        return result;
    }

    public static float checkResultFloat(Object obj, float result) {
        if (result < 0.0f) {
            throw new IndigoException(obj, lib.indigoGetLastError());
        }
        return result;
    }

    public static double checkResultDouble(Object obj, double result) {
        if (result < 0.0) {
            throw new IndigoException(obj, lib.indigoGetLastError());
        }
        return result;
    }

    public static String checkResultString(Object obj, Pointer result) {
        if (result == Pointer.NULL) {
            throw new IndigoException(obj, lib.indigoGetLastError());
        }
        return result.getString(0L);
    }

    public static Pointer checkResultPointer(Object obj, Pointer result) {
        if (result == Pointer.NULL) {
            throw new IndigoException(obj, lib.indigoGetLastError());
        }
        return result;
    }

    public static int[] toIntArray(Collection<Integer> collection) {
        if (collection == null) {
            return new int[0];
        }
        int[] res = new int[collection.size()];
        int i = 0;
        for (Integer x : collection) {
            res[i++] = x;
        }
        return res;
    }

    public static float[] toFloatArray(Collection<Float> collection) {
        if (collection == null) {
            return new float[0];
        }
        float[] res = new float[collection.size()];
        int i = 0;
        for (Float x : collection) {
            res[i++] = x.floatValue();
        }
        return res;
    }

    private static synchronized void loadIndigo(String path) throws FileNotFoundException {
        if (lib != null) {
            return;
        }
        if (Platform.isLinux() || Platform.isSolaris()) {
            lib = (IndigoLib)Native.load((String)IndigoUtils.getPathToBinary(Indigo.class, dllpath, path, LIBINDIGO_SO), IndigoLib.class);
        } else if (Platform.isMac()) {
            lib = (IndigoLib)Native.load((String)IndigoUtils.getPathToBinary(Indigo.class, dllpath, path, LIBINDIGO_DYLIB), IndigoLib.class);
        } else if (Platform.isWindows()) {
            for (String dllName : WIN_DLLS) {
                try {
                    System.load(IndigoUtils.getPathToBinary(Indigo.class, dllpath, path, dllName));
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            lib = (IndigoLib)Native.load((String)IndigoUtils.getPathToBinary(Indigo.class, dllpath, path, INDIGO_DLL), IndigoLib.class);
        }
    }

    public static String getPlatformDependentPath() {
        return dllpath;
    }

    public static IndigoLib getLibrary() {
        return lib;
    }

    public boolean sessionReleased() {
        return this.session_released;
    }

    public String version() {
        return lib.indigoVersion();
    }

    public String versionInfo() {
        return lib.indigoVersionInfo();
    }

    public int countReferences() {
        this.setSessionID();
        return Indigo.checkResult(this, lib.indigoCountReferences());
    }

    public void setSessionID() {
        lib.indigoSetSessionId(this.sid);
    }

    public void setOption(String option, String value) {
        this.setSessionID();
        Indigo.checkResult(this, lib.indigoSetOption(option, value));
    }

    public void setOption(String option, int value) {
        this.setSessionID();
        Indigo.checkResult(this, lib.indigoSetOptionInt(option, value));
    }

    public void setOption(String option, int x, int y) {
        this.setSessionID();
        Indigo.checkResult(this, lib.indigoSetOptionXY(option, x, y));
    }

    public void setOption(String option, float r, float g, float b) {
        this.setSessionID();
        Indigo.checkResult(this, lib.indigoSetOptionColor(option, r, g, b));
    }

    public void setOption(String option, boolean value) {
        this.setSessionID();
        Indigo.checkResult(this, lib.indigoSetOptionBool(option, value ? 1 : 0));
    }

    public void setOption(String option, float value) {
        this.setSessionID();
        Indigo.checkResult(this, lib.indigoSetOptionFloat(option, value));
    }

    public void setOption(String option, double value) {
        this.setSessionID();
        Indigo.checkResult(this, lib.indigoSetOptionFloat(option, (float)value));
    }

    public String getOption(String option) {
        this.setSessionID();
        return Indigo.checkResultString(this, lib.indigoGetOption(option));
    }

    public Integer getOptionInt(String option) {
        this.setSessionID();
        IntByReference res = new IntByReference();
        if (Indigo.checkResult(this, lib.indigoGetOptionInt(option, res)) == 1) {
            return res.getValue();
        }
        return null;
    }

    public boolean getOptionBool(String option) {
        this.setSessionID();
        IntByReference res = new IntByReference();
        Indigo.checkResult(this, lib.indigoGetOptionBool(option, res));
        return res.getValue() > 0;
    }

    public Float getOptionFloat(String option) {
        this.setSessionID();
        FloatByReference res = new FloatByReference();
        if (Indigo.checkResult(this, lib.indigoGetOptionFloat(option, res)) == 1) {
            return Float.valueOf(res.getValue());
        }
        return null;
    }

    public String getOptionType(String option) {
        this.setSessionID();
        return Indigo.checkResultString(this, lib.indigoGetOptionType(option));
    }

    public void resetOptions() {
        this.setSessionID();
        Indigo.checkResult(this, lib.indigoResetOptions());
    }

    public IndigoObject writeFile(String filename) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoWriteFile(filename)));
    }

    public IndigoObject writeBuffer() {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoWriteBuffer()));
    }

    public IndigoObject createMolecule() {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoCreateMolecule()));
    }

    public IndigoObject createQueryMolecule() {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoCreateQueryMolecule()));
    }

    public IndigoObject loadMolecule(String str) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadMoleculeFromString(str)));
    }

    public IndigoObject loadMolecule(byte[] buf) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadMoleculeFromBuffer(buf, buf.length)));
    }

    public IndigoObject loadMoleculeFromFile(String path) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadMoleculeFromFile(path)));
    }

    public IndigoObject loadMoleculeFromBuffer(byte[] buf) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadMoleculeFromBuffer(buf, buf.length)));
    }

    public IndigoObject loadMoleculeWithLib(String str, IndigoObject library) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadMoleculeWithLibFromString(str, library.self)));
    }

    public IndigoObject loadMoleculeWithLib(byte[] buf, IndigoObject library) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadMoleculeWithLibFromBuffer(buf, buf.length, library.self)));
    }

    public IndigoObject loadMoleculeWithLibFromFile(String path, IndigoObject library) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadMoleculeWithLibFromFile(path, library.self)));
    }

    public IndigoObject loadQueryMolecule(String str) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadQueryMoleculeFromString(str)));
    }

    public IndigoObject loadQueryMolecule(byte[] buf) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadQueryMoleculeFromBuffer(buf, buf.length)));
    }

    public IndigoObject loadQueryMoleculeFromFile(String path) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadQueryMoleculeFromFile(path)));
    }

    public IndigoObject loadQueryMoleculeWithLib(String str, IndigoObject library) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadQueryMoleculeWithLibFromString(str, library.self)));
    }

    public IndigoObject loadQueryMoleculeWithLib(byte[] buf, IndigoObject library) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadQueryMoleculeWithLibFromBuffer(buf, buf.length, library.self)));
    }

    public IndigoObject loadQueryMoleculeWithLibFromFile(String path, IndigoObject library) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadQueryMoleculeWithLibFromFile(path, library.self)));
    }

    public IndigoObject loadSmarts(String str) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadSmartsFromString(str)));
    }

    public IndigoObject loadSmarts(byte[] buf) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadSmartsFromBuffer(buf, buf.length)));
    }

    public IndigoObject loadSmartsFromFile(String path) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadSmartsFromFile(path)));
    }

    public IndigoObject loadMonomerLibrary(String str) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadMonomerLibraryFromString(str)));
    }

    public IndigoObject loadMonomerLibraryFromFile(String path) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadMonomerLibraryFromFile(path)));
    }

    public IndigoObject loadKetDocument(String str) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadKetDocumentFromString(str)));
    }

    public IndigoObject loadKetDocumentFromFile(String path) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadKetDocumentFromFile(path)));
    }

    public IndigoObject loadSequence(String str, String seq_type, IndigoObject library) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadSequenceFromString(str, seq_type, library.self)));
    }

    public IndigoObject loadSequenceFromFile(String path, String seq_type, IndigoObject library) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadSequenceFromFile(path, seq_type, library.self)));
    }

    public IndigoObject loadFasta(String str, String seq_type, IndigoObject library) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadFastaFromString(str, seq_type, library.self)));
    }

    public IndigoObject loadFastaFromFile(String path, String seq_type, IndigoObject library) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadFastaFromFile(path, seq_type, library.self)));
    }

    public IndigoObject loadIdt(String str, IndigoObject library) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadIdtFromString(str, library.self)));
    }

    public IndigoObject loadIdtFromFile(String path, IndigoObject library) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadIdtFromFile(path, library.self)));
    }

    public IndigoObject loadHelm(String str, IndigoObject library) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadHelmFromString(str, library.self)));
    }

    public IndigoObject loadHelmFromFile(String path, IndigoObject library) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadHelmFromFile(path, library.self)));
    }

    public IndigoObject loadAxoLabs(String str, IndigoObject library) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadAxoLabsFromString(str, library.self)));
    }

    public IndigoObject loadAxoLabsFromFile(String path, IndigoObject library) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadAxoLabsFromFile(path, library.self)));
    }

    public IndigoObject loadReaction(String str) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadReactionFromString(str)));
    }

    public IndigoObject loadReaction(byte[] buf) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadReactionFromBuffer(buf, buf.length)));
    }

    public IndigoObject loadReactionFromFile(String path) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadReactionFromFile(path)));
    }

    public IndigoObject loadQueryReaction(String str) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadQueryReactionFromString(str)));
    }

    public IndigoObject loadQueryReaction(byte[] buf) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadQueryReactionFromBuffer(buf, buf.length)));
    }

    public IndigoObject loadQueryReactionFromFile(String path) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadQueryReactionFromFile(path)));
    }

    public IndigoObject loadReactionWithLib(String str, IndigoObject library) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadReactionWithLibFromString(str, library.self)));
    }

    public IndigoObject loadReactionWithLib(byte[] buf, IndigoObject library) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadReactionWithLibFromBuffer(buf, buf.length, library.self)));
    }

    public IndigoObject loadReactionWithLibFromFile(String path, IndigoObject library) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadReactionWithLibFromFile(path, library.self)));
    }

    public IndigoObject loadQueryReactionWithLib(String str, IndigoObject library) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadQueryReactionWithLibFromString(str, library.self)));
    }

    public IndigoObject loadQueryReactionWithLib(byte[] buf, IndigoObject library) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadQueryReactionWithLibFromBuffer(buf, buf.length, library.self)));
    }

    public IndigoObject loadQueryReactionWithLibFromFile(String path, IndigoObject library) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadQueryReactionWithLibFromFile(path, library.self)));
    }

    public IndigoObject loadReactionSmarts(String str) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadReactionSmartsFromString(str)));
    }

    public IndigoObject loadReactionSmarts(byte[] buf) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadReactionSmartsFromBuffer(buf, buf.length)));
    }

    public IndigoObject loadReactionSmartsFromFile(String path) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadReactionSmartsFromFile(path)));
    }

    public String checkStructure(String str) {
        return this.checkStructure(str, "");
    }

    public String checkStructure(String str, String params) {
        this.setSessionID();
        return Indigo.checkResultString(this, lib.indigoCheckStructure(str, params));
    }

    public String check(String str, String type, String params) {
        this.setSessionID();
        return Indigo.checkResultString(this, lib.indigoCheck(str, type, params));
    }

    public IndigoObject loadStructure(String str) {
        return this.loadStructure(str, "");
    }

    public IndigoObject loadStructure(String str, String params) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadStructureFromString(str, params)));
    }

    public IndigoObject loadStructure(byte[] buf) {
        return this.loadStructure(buf, "");
    }

    public IndigoObject loadStructure(byte[] buf, String params) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadStructureFromBuffer(buf, buf.length, params)));
    }

    public IndigoObject loadStructureFromFile(String path) {
        return this.loadStructureFromFile(path, "");
    }

    public IndigoObject loadStructureFromFile(String path, String params) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadStructureFromFile(path, params)));
    }

    public IndigoObject loadStructureFromBuffer(byte[] buf) {
        return this.loadStructureFromBuffer(buf, "");
    }

    public IndigoObject loadStructureFromBuffer(byte[] buf, String params) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadStructureFromBuffer(buf, buf.length, params)));
    }

    public IndigoObject loadFingerprintFromBuffer(byte[] buf) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadFingerprintFromBuffer(buf, buf.length)));
    }

    public IndigoObject loadFingerprintFromDescriptors(double[] descriptors, int size, double density) {
        this.setSessionID();
        int result = lib.indigoLoadFingerprintFromDescriptors(descriptors, descriptors.length, size, density);
        return new IndigoObject(this, Indigo.checkResult(this, result));
    }

    public IndigoObject createReaction() {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoCreateReaction()));
    }

    public IndigoObject createQueryReaction() {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoCreateQueryReaction()));
    }

    public IndigoObject exactMatch(IndigoObject obj1, IndigoObject obj2, String flags) {
        if (flags == null) {
            flags = "";
        }
        IndigoObject[] parent = new IndigoObject[]{obj1, obj2};
        this.setSessionID();
        int match = Indigo.checkResult(this, parent, lib.indigoExactMatch(obj1.self, obj2.self, flags));
        if (match == 0) {
            return null;
        }
        return new IndigoObject(this, match, parent);
    }

    public IndigoObject exactMatch(IndigoObject obj1, IndigoObject obj2) {
        return this.exactMatch(obj1, obj2, "");
    }

    public void setTautomerRule(int id, String beg, String end) {
        this.setSessionID();
        Indigo.checkResult(this, lib.indigoSetTautomerRule(id, beg, end));
    }

    public void removeTautomerRule(int id) {
        this.setSessionID();
        Indigo.checkResult(this, lib.indigoRemoveTautomerRule(id));
    }

    public void clearTautomerRules() {
        this.setSessionID();
        Indigo.checkResult(this, lib.indigoClearTautomerRules());
    }

    public float similarity(IndigoObject obj1, IndigoObject obj2) {
        return this.similarity(obj1, obj2, "");
    }

    public float similarity(IndigoObject obj1, IndigoObject obj2, String metrics) {
        if (metrics == null) {
            metrics = "";
        }
        Object[] guard = new Object[]{this, obj1, obj2};
        this.setSessionID();
        return Indigo.checkResultFloat(guard, lib.indigoSimilarity(obj1.self, obj2.self, metrics));
    }

    public int commonBits(IndigoObject fingerprint1, IndigoObject fingerprint2) {
        Object[] guard = new Object[]{this, fingerprint1, fingerprint2};
        this.setSessionID();
        return Indigo.checkResult(guard, lib.indigoCommonBits(fingerprint1.self, fingerprint2.self));
    }

    @Deprecated
    public IndigoObject unserialize(byte[] data) {
        return this.deserialize(data);
    }

    public IndigoObject deserialize(byte[] data) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoUnserialize(data, data.length)));
    }

    public IndigoObject createArray() {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoCreateArray()));
    }

    public IndigoObject iterateSDFile(String filename) {
        this.setSessionID();
        int result = Indigo.checkResult(this, lib.indigoIterateSDFile(filename));
        if (result == 0) {
            return null;
        }
        return new IndigoObject(this, result);
    }

    public IndigoObject iterateRDFile(String filename) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoIterateRDFile(filename)));
    }

    public IndigoObject iterateSmilesFile(String filename) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoIterateSmilesFile(filename)));
    }

    public IndigoObject iterateCMLFile(String filename) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoIterateCMLFile(filename)));
    }

    public IndigoObject iterateCDXFile(String filename) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoIterateCDXFile(filename)));
    }

    public IndigoObject substructureMatcher(IndigoObject target, String mode) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, target, lib.indigoSubstructureMatcher(target.self, mode)), target);
    }

    public IndigoObject substructureMatcher(IndigoObject target) {
        return this.substructureMatcher(target, "");
    }

    public IndigoObject extractCommonScaffold(IndigoObject structures, String options) {
        this.setSessionID();
        int res = Indigo.checkResult(this, structures, lib.indigoExtractCommonScaffold(structures.self, options));
        if (res == 0) {
            return null;
        }
        return new IndigoObject(this, res);
    }

    public IndigoObject extractCommonScaffold(Collection<IndigoObject> structures, String options) {
        return this.extractCommonScaffold(this.toIndigoArray(structures), options);
    }

    public IndigoObject rgroupComposition(IndigoObject molecule, String options) {
        this.setSessionID();
        int res = Indigo.checkResult(this, molecule, lib.indigoRGroupComposition(molecule.self, options));
        if (res == 0) {
            return null;
        }
        return new IndigoObject(this, res);
    }

    public IndigoObject getFragmentedMolecule(IndigoObject molecule, String options) {
        this.setSessionID();
        int res = Indigo.checkResult(this, molecule, lib.indigoGetFragmentedMolecule(molecule.self, options));
        if (res == 0) {
            return null;
        }
        return new IndigoObject(this, res);
    }

    @Deprecated
    public IndigoObject decomposeMolecules(IndigoObject scaffold, IndigoObject structures) {
        Object[] guard = new Object[]{this, scaffold, structures};
        this.setSessionID();
        int res = Indigo.checkResult(guard, lib.indigoDecomposeMolecules(scaffold.self, structures.self));
        if (res == 0) {
            return null;
        }
        return new IndigoObject(this, res);
    }

    @Deprecated
    public IndigoObject decomposeMolecules(IndigoObject scaffold, Collection<IndigoObject> structures) {
        return this.decomposeMolecules(scaffold, this.toIndigoArray(structures));
    }

    public IndigoObject createDecomposer(IndigoObject scaffold) {
        Object[] guard = new Object[]{this, scaffold};
        this.setSessionID();
        int res = Indigo.checkResult(guard, lib.indigoCreateDecomposer(scaffold.self));
        if (res == 0) {
            return null;
        }
        return new IndigoObject(this, res);
    }

    public IndigoObject reactionProductEnumerate(IndigoObject reaction, IndigoObject monomers) {
        Object[] guard = new Object[]{this, reaction, monomers};
        this.setSessionID();
        int res = Indigo.checkResult(guard, lib.indigoReactionProductEnumerate(reaction.self, monomers.self));
        if (res == 0) {
            return null;
        }
        return new IndigoObject(this, res);
    }

    public IndigoObject reactionProductEnumerate(IndigoObject reaction, Iterable<Iterable<IndigoObject>> monomers) {
        Object[] guard = new Object[]{this, reaction, monomers};
        IndigoObject monomersArrayArray = this.createArray();
        for (Iterable<IndigoObject> iter : monomers) {
            IndigoObject monomersArray = this.createArray();
            for (IndigoObject monomer : iter) {
                monomersArray.arrayAdd(monomer);
            }
            monomersArrayArray.arrayAdd(monomersArray);
        }
        this.setSessionID();
        int res = Indigo.checkResult(guard, lib.indigoReactionProductEnumerate(reaction.self, monomersArrayArray.self));
        if (res == 0) {
            return null;
        }
        return new IndigoObject(this, res);
    }

    public IndigoObject transform(IndigoObject reaction, IndigoObject monomer) {
        Object[] guard = new Object[]{this, reaction, monomer};
        this.setSessionID();
        int res = Indigo.checkResult(guard, lib.indigoTransform(reaction.self, monomer.self));
        if (res == 0) {
            return null;
        }
        return new IndigoObject(this, res);
    }

    public IndigoObject createSaver(IndigoObject output, String format) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, output, lib.indigoCreateSaver(output.self, format)), output);
    }

    public IndigoObject createFileSaver(String filename, String format) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoCreateFileSaver(filename, format)));
    }

    public void dbgBreakpoint() {
        this.setSessionID();
        lib.indigoDbgBreakpoint();
    }

    public IndigoObject toIndigoArray(Collection<IndigoObject> coll) {
        this.setSessionID();
        IndigoObject arr = this.createArray();
        for (IndigoObject obj : coll) {
            arr.arrayAdd(obj);
        }
        return arr;
    }

    public String getUserSpecifiedPath() {
        return this.path;
    }

    public long getSid() {
        return this.sid;
    }

    public IndigoObject loadBuffer(byte[] buf) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadBuffer(buf, buf.length)));
    }

    public IndigoObject loadString(String string) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, lib.indigoLoadString(string)));
    }

    public IndigoObject iterateSDF(IndigoObject reader) {
        this.setSessionID();
        int result = Indigo.checkResult(this, lib.indigoIterateSDF(reader.self));
        if (result == 0) {
            return null;
        }
        return new IndigoObject(this, result, reader);
    }

    public IndigoObject iterateRDF(IndigoObject reader) {
        this.setSessionID();
        int result = Indigo.checkResult(this, lib.indigoIterateRDF(reader.self));
        if (result == 0) {
            return null;
        }
        return new IndigoObject(this, result, reader);
    }

    public IndigoObject iterateCML(IndigoObject reader) {
        this.setSessionID();
        int result = Indigo.checkResult(this, lib.indigoIterateCML(reader.self));
        if (result == 0) {
            return null;
        }
        return new IndigoObject(this, result, reader);
    }

    public IndigoObject iterateCDX(IndigoObject reader) {
        this.setSessionID();
        int result = Indigo.checkResult(this, lib.indigoIterateCDX(reader.self));
        if (result == 0) {
            return null;
        }
        return new IndigoObject(this, result, reader);
    }

    public IndigoObject iterateSmiles(IndigoObject reader) {
        this.setSessionID();
        int result = Indigo.checkResult(this, lib.indigoIterateSmiles(reader.self));
        if (result == 0) {
            return null;
        }
        return new IndigoObject(this, result, reader);
    }

    public IndigoObject iterateTautomers(IndigoObject molecule, String params) {
        this.setSessionID();
        int result = Indigo.checkResult(this, lib.indigoIterateTautomers(molecule.self, params));
        if (result == 0) {
            return null;
        }
        return new IndigoObject(this, result, molecule);
    }

    public int buildPkaModel(int level, float threshold, String filename) {
        this.setSessionID();
        return Indigo.checkResult(this, lib.indigoBuildPkaModel(level, threshold, filename));
    }

    public IndigoObject nameToStructure(String name) {
        return this.nameToStructure(name, "");
    }

    public IndigoObject nameToStructure(String name, String params) {
        if (params == null) {
            params = "";
        }
        this.setSessionID();
        int result = Indigo.checkResult(this, lib.indigoNameToStructure(name, params));
        if (result == 0) {
            return null;
        }
        return new IndigoObject(this, result);
    }

    public IndigoObject transformHELMtoSCSR(IndigoObject item) {
        this.setSessionID();
        int result = Indigo.checkResult(this, lib.indigoTransformHELMtoSCSR(item.self));
        if (result == 0) {
            return null;
        }
        return new IndigoObject(this, result);
    }

    public void finalize() throws Throwable {
        if (!this.sessionReleased()) {
            lib.indigoReleaseSessionId(this.sid);
            this.session_released = true;
        }
        super.finalize();
    }

    static {
        lib = null;
        dllpath = IndigoUtils.getDllPath();
    }
}

