/*
 * Decompiled with CFR 0.152.
 */
package com.epam.indigo;

import com.epam.indigo.Indigo;
import com.epam.indigo.IndigoException;
import com.epam.indigo.IndigoObject;
import com.epam.indigo.IndigoRendererLib;
import com.epam.indigo.IndigoUtils;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.FileNotFoundException;

public class IndigoRenderer {
    final Indigo indigo;
    static IndigoRendererLib lib;
    boolean initialized;

    public IndigoRenderer(Indigo indigo) {
        IndigoRenderer.loadLibrary(indigo.getUserSpecifiedPath());
        this.indigo = indigo;
        this.indigo.setSessionID();
        Indigo.checkResult((Object)this, (int)lib.indigoRendererInit(this.indigo.getSid()));
        this.initialized = true;
    }

    public void finalize() throws Throwable {
        if (this.initialized) {
            this.indigo.setSessionID();
            Indigo.checkResult((Object)this, (int)lib.indigoRendererDispose(this.indigo.getSid()));
            super.finalize();
            this.initialized = false;
        }
    }

    public void render(IndigoObject obj, IndigoObject output) {
        this.indigo.setSessionID();
        Object[] guard = new Object[]{this, obj, output};
        Indigo.checkResult((Object)guard, (int)lib.indigoRender(obj.self, output.self));
    }

    public void renderToFile(IndigoObject obj, String filename) {
        this.indigo.setSessionID();
        Indigo.checkResult((Object)this, (Object)obj, (int)lib.indigoRenderToFile(obj.self, filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] renderToBuffer(IndigoObject obj) {
        this.indigo.setSessionID();
        IndigoObject buf = this.indigo.writeBuffer();
        try {
            Indigo.checkResult((Object)this, (Object)obj, (int)lib.indigoRender(obj.self, buf.self));
            byte[] byArray = buf.toBuffer();
            return byArray;
        }
        finally {
            buf.dispose();
        }
    }

    public void renderGridToFile(IndigoObject objects, int[] refAtoms, int ncolumns, String filename) {
        this.indigo.setSessionID();
        if (refAtoms != null && objects.count() != refAtoms.length) {
            throw new IndigoException((Object)this, "refAtoms size does not match the number of objects");
        }
        Indigo.checkResult((Object)this, (Object)objects, (int)lib.indigoRenderGridToFile(objects.self, refAtoms, ncolumns, filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] renderGridToBuffer(IndigoObject objects, int[] refAtoms, int ncolumns) {
        this.indigo.setSessionID();
        if (refAtoms != null && objects.count() != refAtoms.length) {
            throw new IndigoException((Object)this, "refAtoms size does not match the number of objects");
        }
        IndigoObject buf = this.indigo.writeBuffer();
        try {
            Indigo.checkResult((Object)this, (Object)objects, (int)lib.indigoRenderGrid(objects.self, refAtoms, ncolumns, buf.self));
            byte[] byArray = buf.toBuffer();
            return byArray;
        }
        finally {
            buf.dispose();
        }
    }

    public void renderResetSettings() {
        this.indigo.setSessionID();
        lib.indigoRenderReset();
    }

    private static synchronized void loadLibrary(String path) {
        if (lib != null) {
            return;
        }
        try {
            if (Platform.isLinux() || Platform.isSolaris()) {
                lib = (IndigoRendererLib)Native.load((String)IndigoUtils.getPathToBinary(IndigoRenderer.class, (String)Indigo.getPlatformDependentPath(), (String)path, (String)"libindigo-renderer.so"), IndigoRendererLib.class);
            } else if (Platform.isMac()) {
                lib = (IndigoRendererLib)Native.load((String)IndigoUtils.getPathToBinary(IndigoRenderer.class, (String)Indigo.getPlatformDependentPath(), (String)path, (String)"libindigo-renderer.dylib"), IndigoRendererLib.class);
            } else if (Platform.isWindows()) {
                lib = (IndigoRendererLib)Native.load((String)IndigoUtils.getPathToBinary(IndigoRenderer.class, (String)Indigo.getPlatformDependentPath(), (String)path, (String)"indigo-renderer.dll"), IndigoRendererLib.class);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

