/*
 * Decompiled with CFR 0.152.
 */
package com.epam.indigo;

import com.epam.indigo.Bingo;
import com.epam.indigo.BingoLib;
import com.epam.indigo.Indigo;
import com.epam.indigo.IndigoObject;
import com.sun.jna.ptr.FloatByReference;

public class BingoObject {
    private int id;
    private final Indigo indigo;
    private final BingoLib bingoLib;
    private Object reference;

    BingoObject(int id, Indigo indigo, BingoLib bingo_lib) {
        this.id = id;
        this.indigo = indigo;
        this.bingoLib = bingo_lib;
    }

    protected void finalize() {
        this.dispose();
    }

    public void dispose() {
        if (this.id >= 0) {
            Bingo.checkResult(this.indigo, this.bingoLib.bingoEndSearch(this.id));
            this.id = -1;
        }
    }

    public void close() {
        this.dispose();
    }

    public boolean next() {
        this.indigo.setSessionID();
        return this.bingoLib.bingoNext(this.id) == 1;
    }

    public int getCurrentId() {
        this.indigo.setSessionID();
        return Bingo.checkResult(this.indigo, this.bingoLib.bingoGetCurrentId(this.id));
    }

    public float getCurrentSimilarityValue() {
        this.indigo.setSessionID();
        return Bingo.checkResult(this.indigo, this.bingoLib.bingoGetCurrentSimilarityValue(this.id));
    }

    public IndigoObject getIndigoObject() {
        this.indigo.setSessionID();
        IndigoObject res = new IndigoObject(this.indigo, Bingo.checkResult(this.indigo, this.bingoLib.bingoGetObject(this.id)));
        this.reference = res;
        return res;
    }

    public int estimateRemainingResultsCount() {
        this.indigo.setSessionID();
        return Bingo.checkResult(this.indigo, this.bingoLib.bingoEstimateRemainingResultsCount(this.id));
    }

    public int estimateRemainingResultsCountError() {
        this.indigo.setSessionID();
        return Bingo.checkResult(this.indigo, this.bingoLib.bingoEstimateRemainingResultsCountError(this.id));
    }

    public float estimateRemainingTime() {
        FloatByReference estimated_time = new FloatByReference();
        this.indigo.setSessionID();
        Bingo.checkResult(this.indigo, this.bingoLib.bingoEstimateRemainingTime(this.id, estimated_time));
        return estimated_time.getValue();
    }
}

