/*
 * Decompiled with CFR 0.152.
 */
package com.epam.indigo;

import com.epam.indigo.BingoException;
import com.epam.indigo.BingoLib;
import com.epam.indigo.BingoObject;
import com.epam.indigo.Indigo;
import com.epam.indigo.IndigoObject;
import com.epam.indigo.IndigoUtils;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.FileNotFoundException;

public class Bingo {
    private final Indigo indigo;
    private static BingoLib lib;
    private int id;

    public Bingo(Indigo indigo, String location, String type, String options) {
        Bingo.loadLibrary(indigo.getUserSpecifiedPath());
        this.id = Bingo.checkResult(indigo, lib.bingoCreateDatabaseFile(location, type, options));
        this.indigo = indigo;
    }

    public Bingo(Indigo indigo, String location, String options) {
        Bingo.loadLibrary(indigo.getUserSpecifiedPath());
        this.indigo = indigo;
        this.indigo.setSessionID();
        this.id = Bingo.checkResult(indigo, lib.bingoLoadDatabaseFile(location, options));
    }

    protected void finalize() {
        this.dispose();
    }

    private static synchronized void loadLibrary(String path) {
        if (lib != null) {
            return;
        }
        try {
            if (Platform.isLinux() || Platform.isSolaris()) {
                lib = (BingoLib)Native.load((String)IndigoUtils.getPathToBinary(Bingo.class, (String)Indigo.getPlatformDependentPath(), (String)path, (String)"libbingo-nosql.so"), BingoLib.class);
            } else if (Platform.isMac()) {
                lib = (BingoLib)Native.load((String)IndigoUtils.getPathToBinary(Bingo.class, (String)Indigo.getPlatformDependentPath(), (String)path, (String)"libbingo-nosql.dylib"), BingoLib.class);
            } else if (Platform.isWindows()) {
                lib = (BingoLib)Native.load((String)IndigoUtils.getPathToBinary(Bingo.class, (String)Indigo.getPlatformDependentPath(), (String)path, (String)"bingo-nosql.dll"), BingoLib.class);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void dispose() {
        if (this.id >= 0) {
            this.indigo.setSessionID();
            Bingo.checkResult(this.indigo, lib.bingoCloseDatabase(this.id));
            this.id = -1;
        }
    }

    public void close() {
        this.dispose();
    }

    public static int checkResult(Indigo indigo, int result) {
        if (result < 0) {
            throw new BingoException(indigo, Indigo.getLibrary().indigoGetLastError());
        }
        return result;
    }

    public static float checkResult(Indigo indigo, float result) {
        if ((double)result < 0.0) {
            throw new BingoException(indigo, Indigo.getLibrary().indigoGetLastError());
        }
        return result;
    }

    public static String checkResult(Indigo indigo, String result) {
        if (result == null) {
            throw new BingoException(indigo, Indigo.getLibrary().indigoGetLastError());
        }
        return result;
    }

    public static Bingo createDatabaseFile(Indigo indigo, String location, String type, String options) {
        indigo.setSessionID();
        if (options == null) {
            options = "";
        }
        return new Bingo(indigo, location, type, options);
    }

    public static Bingo createDatabaseFile(Indigo indigo, String location, String type) {
        return Bingo.createDatabaseFile(indigo, location, type, null);
    }

    public static Bingo loadDatabaseFile(Indigo indigo, String location, String options) {
        if (options == null) {
            options = "";
        }
        return new Bingo(indigo, location, options);
    }

    public static Bingo loadDatabaseFile(Indigo indigo, String location) {
        return Bingo.loadDatabaseFile(indigo, location, null);
    }

    public int insert(IndigoObject record) {
        this.indigo.setSessionID();
        return Bingo.checkResult(this.indigo, lib.bingoInsertRecordObj(this.id, record.self));
    }

    public int insert(IndigoObject record, int id) {
        this.indigo.setSessionID();
        return Bingo.checkResult(this.indigo, lib.bingoInsertRecordObjWithId(this.id, record.self, id));
    }

    public int insertWithExtFP(IndigoObject record, IndigoObject ext_fp) {
        this.indigo.setSessionID();
        return Bingo.checkResult(this.indigo, lib.bingoInsertRecordObjWithExtFP(this.id, record.self, ext_fp.self));
    }

    public int insertWithExtFP(IndigoObject record, IndigoObject ext_fp, int id) {
        this.indigo.setSessionID();
        return Bingo.checkResult(this.indigo, lib.bingoInsertRecordObjWithIdAndExtFP(this.id, record.self, id, ext_fp.self));
    }

    public void delete(int id) {
        this.indigo.setSessionID();
        Bingo.checkResult(this.indigo, lib.bingoDeleteRecord(this.id, id));
    }

    public BingoObject searchSub(IndigoObject query, String options) {
        if (options == null) {
            options = "";
        }
        this.indigo.setSessionID();
        return new BingoObject(Bingo.checkResult(this.indigo, lib.bingoSearchSub(this.id, query.self, options)), this.indigo, lib);
    }

    public BingoObject searchSub(IndigoObject query) {
        return this.searchSub(query, null);
    }

    public BingoObject searchSim(IndigoObject query, float min, float max, String metric) {
        if (metric == null) {
            metric = "tanimoto";
        }
        this.indigo.setSessionID();
        return new BingoObject(Bingo.checkResult(this.indigo, lib.bingoSearchSim(this.id, query.self, min, max, metric)), this.indigo, lib);
    }

    public BingoObject searchSim(IndigoObject query, float min, float max) {
        return this.searchSim(query, min, max, null);
    }

    public BingoObject searchSimWithExtFP(IndigoObject query, float min, float max, IndigoObject ext_fp, String metric) {
        if (metric == null) {
            metric = "tanimoto";
        }
        this.indigo.setSessionID();
        return new BingoObject(Bingo.checkResult(this.indigo, lib.bingoSearchSimWithExtFP(this.id, query.self, min, max, ext_fp.self, metric)), this.indigo, lib);
    }

    public BingoObject searchSimWithExtFP(IndigoObject query, float min, float max, IndigoObject ext_fp) {
        return this.searchSimWithExtFP(query, min, max, ext_fp, null);
    }

    public BingoObject searchSimTopN(IndigoObject query, int limit, float minSim, String metric) {
        if (metric == null) {
            metric = "tanimoto";
        }
        this.indigo.setSessionID();
        return new BingoObject(Bingo.checkResult(this.indigo, lib.bingoSearchSimTopN(this.id, query.self, limit, minSim, metric)), this.indigo, lib);
    }

    public BingoObject searchSimTopN(IndigoObject query, int limit, float minSim) {
        return this.searchSimTopN(query, limit, minSim, null);
    }

    public BingoObject searchSimTopNWithExtFP(IndigoObject query, int limit, float minSim, IndigoObject extFp, String metric) {
        if (metric == null) {
            metric = "tanimoto";
        }
        this.indigo.setSessionID();
        return new BingoObject(Bingo.checkResult(this.indigo, lib.bingoSearchSimTopNWithExtFP(this.id, query.self, limit, minSim, extFp.self, metric)), this.indigo, lib);
    }

    public BingoObject searchSimTopNWithExtFP(IndigoObject query, int limit, float minSim, IndigoObject extFp) {
        return this.searchSimTopNWithExtFP(query, limit, minSim, extFp, null);
    }

    public BingoObject enumerateId() {
        this.indigo.setSessionID();
        return new BingoObject(Bingo.checkResult(this.indigo, lib.bingoEnumerateId(this.id)), this.indigo, lib);
    }

    public BingoObject searchExact(IndigoObject query, String options) {
        if (options == null) {
            options = "";
        }
        this.indigo.setSessionID();
        return new BingoObject(Bingo.checkResult(this.indigo, lib.bingoSearchExact(this.id, query.self, options)), this.indigo, lib);
    }

    public BingoObject searchExact(IndigoObject query) {
        return this.searchExact(query, null);
    }

    public BingoObject searchMolFormula(String query, String options) {
        if (options == null) {
            options = "";
        }
        this.indigo.setSessionID();
        return new BingoObject(Bingo.checkResult(this.indigo, lib.bingoSearchMolFormula(this.id, query, options)), this.indigo, lib);
    }

    public BingoObject searchMolFormula(String query) {
        return this.searchMolFormula(query, null);
    }

    public void optimize() {
        this.indigo.setSessionID();
        Bingo.checkResult(this.indigo, lib.bingoOptimize(this.id));
    }

    public IndigoObject getRecordById(int id) {
        this.indigo.setSessionID();
        return new IndigoObject(this.indigo, Bingo.checkResult(this.indigo, lib.bingoGetRecordObj(this.id, id)));
    }

    public String version() {
        this.indigo.setSessionID();
        return Bingo.checkResult(this.indigo, lib.bingoVersion());
    }
}

