-- Copyright (C) from 2009 to Present EPAM Systems.
-- 
-- This file is part of Indigo toolkit.
-- 
-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
-- 
-- http://www.apache.org/licenses/LICENSE-2.0
-- 
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.

set verify off
spool mango_package;

CREATE OR REPLACE PACKAGE MangoPackage IS
   function Sub (target in VARCHAR2, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Sub (target in VARCHAR2, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Sub (target in VARCHAR2, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Sub (target in VARCHAR2, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Sub (target in CLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Sub (target in CLOB, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Sub (target in CLOB, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Sub (target in CLOB, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Sub (target in BLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Sub (target in BLOB, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Sub (target in BLOB, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Sub (target in BLOB, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function SubHi (target in VARCHAR2, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function SubHi (target in VARCHAR2, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function SubHi (target in VARCHAR2, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function SubHi (target in VARCHAR2, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function SubHi (target in CLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function SubHi (target in CLOB, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function SubHi (target in CLOB, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function SubHi (target in CLOB, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function SubHi (target in BLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function SubHi (target in BLOB, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function SubHi (target in BLOB, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function SubHi (target in BLOB, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function Smarts (target in VARCHAR2, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Smarts (target in CLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Smarts (target in BLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function SmartsHi (target in VARCHAR2, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function SmartsHi (target in CLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function SmartsHi (target in BLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function Exact (target in VARCHAR2, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Exact (target in VARCHAR2, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Exact (target in VARCHAR2, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Exact (target in VARCHAR2, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Exact (target in CLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Exact (target in CLOB, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Exact (target in CLOB, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Exact (target in CLOB, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Exact (target in BLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Exact (target in BLOB, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Exact (target in BLOB, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Exact (target in BLOB, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function ExactHi (target in VARCHAR2, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function ExactHi (target in VARCHAR2, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function ExactHi (target in VARCHAR2, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function ExactHi (target in VARCHAR2, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function ExactHi (target in CLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function ExactHi (target in CLOB, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function ExactHi (target in CLOB, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function ExactHi (target in CLOB, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function ExactHi (target in BLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function ExactHi (target in BLOB, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function ExactHi (target in BLOB, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function ExactHi (target in BLOB, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB;
   function Sim (target in VARCHAR2, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Sim (target in VARCHAR2, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Sim (target in VARCHAR2, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Sim (target in VARCHAR2, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Sim (target in CLOB, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Sim (target in CLOB, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Sim (target in CLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Sim (target in CLOB, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Sim (target in BLOB, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Sim (target in BLOB, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Sim (target in BLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Sim (target in BLOB, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function GrossCalc (target in VARCHAR2) return VARCHAR2;
   function GrossCalc (target in CLOB) return VARCHAR2;
   function GrossCalc (target in BLOB) return VARCHAR2;
   function Gross (target in VARCHAR2, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                   scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Gross (target in CLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                   scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Gross (target in BLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                   scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Mass (target in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                   scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Mass (target in CLOB, indexctx IN sys.ODCIIndexCtx,
                   scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Mass (target in BLOB, indexctx IN sys.ODCIIndexCtx,
                   scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER;
   function Mass (target in VARCHAR2, typee in VARCHAR2) return NUMBER;
   function Mass (target in CLOB, typee in VARCHAR2) return NUMBER;
   function Mass (target in BLOB, typee in VARCHAR2) return NUMBER;
   function Molfile (target in VARCHAR2) return CLOB;
   function Molfile (target in CLOB) return CLOB;
   function Molfile (target in BLOB) return CLOB;
   function Molfile (target in VARCHAR2, options in VARCHAR2) return CLOB;
   function Molfile (target in CLOB, options in VARCHAR2) return CLOB;
   function Molfile (target in BLOB, options in VARCHAR2) return CLOB;
   function CML (target in VARCHAR2) return CLOB;
   function CML (target in CLOB) return CLOB;
   function CML (target in BLOB) return CLOB;
   function SMILES (target in VARCHAR2) return VARCHAR2;
   function SMILES (target in CLOB) return VARCHAR2;
   function SMILES (target in BLOB) return VARCHAR2;
   function SMILES (target in VARCHAR2, options in VARCHAR2) return VARCHAR2;
   function SMILES (target in CLOB, options in VARCHAR2) return VARCHAR2;
   function SMILES (target in BLOB, options in VARCHAR2) return VARCHAR2;
   function CANSMILES (target in VARCHAR2) return VARCHAR2;
   function CANSMILES (target in CLOB) return VARCHAR2;
   function CANSMILES (target in BLOB) return VARCHAR2;
   function InChI (target in VARCHAR2, options in VARCHAR2) return CLOB;
   function InChI (target in CLOB, options in VARCHAR2) return CLOB;
   function InChI (target in BLOB, options in VARCHAR2) return CLOB;
   function InChIKey (inchi in VARCHAR2) return VARCHAR2;
   function InChIKey (inchi in CLOB) return VARCHAR2;
   function Fingerprint (target in VARCHAR2, options in VARCHAR2) return BLOB;
   function Fingerprint (target in CLOB, options in VARCHAR2) return BLOB;
   function Fingerprint (target in BLOB, options in VARCHAR2) return BLOB;
END MangoPackage;
/
CREATE OR REPLACE PACKAGE BODY MangoPackage IS
   function Sub (target in VARCHAR2, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Sub(to_clob(target), to_clob(query), null, indexctx, scanctx, scanflg);
   end Sub;
   function Sub (target in VARCHAR2, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Sub(to_clob(target), to_clob(query), params, indexctx, scanctx, scanflg);
   end Sub;
   function Sub (target in VARCHAR2, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Sub(to_clob(target), query, null, indexctx, scanctx, scanflg);
   end Sub;
   function Sub (target in VARCHAR2, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Sub(to_clob(target), query, params, indexctx, scanctx, scanflg);
   end Sub;
   function Sub (target in CLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Sub(target, to_clob(query), null, indexctx, scanctx, scanflg);
   end Sub;
   function Sub (target in CLOB, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Sub(target, to_clob(query), params, indexctx, scanctx, scanflg);
   end Sub;
   function Sub (target in CLOB, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Sub(target, query, null, indexctx, scanctx, scanflg);
   end Sub;
   function Sub (target in CLOB, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
      context_id binary_integer := 0;
   begin
      if indexctx.IndexInfo is not null then
         context_id := BingoPackage.getContextID(indexctx.IndexInfo);
      end if;
      return Sub_clob(context_id, target, query, params);
   end Sub;
   function Sub (target in BLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Sub(target, to_clob(query), null, indexctx, scanctx, scanflg);
   end Sub;
   function Sub (target in BLOB, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Sub(target, to_clob(query), params, indexctx, scanctx, scanflg);
   end Sub;
   function Sub (target in BLOB, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Sub(target, query, null, indexctx, scanctx, scanflg);
   end Sub;
   function Sub (target in BLOB, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
      context_id binary_integer := 0;
   begin
      if indexctx.IndexInfo is not null then
         context_id := BingoPackage.getContextID(indexctx.IndexInfo);
      end if;
      return Sub_blob(context_id, target, query, params);
   end Sub;
   function SubHi (target in VARCHAR2, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
   begin
      return SubHi(to_clob(target), to_clob(query), null, indexctx, scanctx, scanflg);
   end SubHi;
   function SubHi (target in VARCHAR2, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
   begin
      return SubHi(to_clob(target), to_clob(query), params, indexctx, scanctx, scanflg);
   end SubHi;
   function SubHi (target in VARCHAR2, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
   begin
      return SubHi(to_clob(target), query, null, indexctx, scanctx, scanflg);
   end SubHi;
   function SubHi (target in VARCHAR2, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
   begin
      return SubHi(to_clob(target), query, params, indexctx, scanctx, scanflg);
   end SubHi;
   function SubHi (target in CLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
   begin
      return SubHi(target, to_clob(query), null, indexctx, scanctx, scanflg);
   end SubHi;
   function SubHi (target in CLOB, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
   begin
      return SubHi(target, to_clob(query), params, indexctx, scanctx, scanflg);
   end SubHi;
   function SubHi (target in CLOB, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
   begin
      return SubHi(target, query, null, indexctx, scanctx, scanflg);
   end SubHi;
   function SubHi (target in CLOB, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
      context_id binary_integer := 0;
   begin
      if indexctx.IndexInfo is not null then
         context_id := BingoPackage.getContextID(indexctx.IndexInfo);
      end if;
      return SubHi_clob(context_id, target, query, params);
   end SubHi;
   function SubHi (target in BLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
   begin
      return SubHi(target, to_clob(query), null, indexctx, scanctx, scanflg);
   end SubHi;
   function SubHi (target in BLOB, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
   begin
      return SubHi(target, to_clob(query), params, indexctx, scanctx, scanflg);
   end SubHi;
   function SubHi (target in BLOB, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
   begin
      return SubHi(target, query, null, indexctx, scanctx, scanflg);
   end SubHi;
   function SubHi (target in BLOB, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
      context_id binary_integer := 0;
   begin
      if indexctx.IndexInfo is not null then
         context_id := BingoPackage.getContextID(indexctx.IndexInfo);
      end if;
      return SubHi_blob(context_id, target, query, params);
   end SubHi;

   function Smarts (target in VARCHAR2, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
      context_id binary_integer := 0;
   begin
      return Smarts(to_clob(target), query, indexctx, scanctx, scanflg);
   end Smarts;
   function Smarts (target in CLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
      context_id binary_integer := 0;
   begin
      if indexctx.IndexInfo is not null then
         context_id := BingoPackage.getContextID(indexctx.IndexInfo);
      end if;
      return Smarts_clob(context_id, target, query);
   end Smarts;
   function Smarts (target in BLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
      context_id binary_integer := 0;
   begin
      if indexctx.IndexInfo is not null then
         context_id := BingoPackage.getContextID(indexctx.IndexInfo);
      end if;
      return Smarts_blob(context_id, target, query);
   end Smarts;

   function SmartsHi (target in VARCHAR2, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
      context_id binary_integer := 0;
   begin
      if indexctx.IndexInfo is not null then
         context_id := BingoPackage.getContextID(indexctx.IndexInfo);
      end if;
      return SmartsHi_clob(context_id, to_clob(target), query);
   end SmartsHi;
   function SmartsHi (target in CLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
      context_id binary_integer := 0;
   begin
      if indexctx.IndexInfo is not null then
         context_id := BingoPackage.getContextID(indexctx.IndexInfo);
      end if;
      return SmartsHi_clob(context_id, target, query);
   end SmartsHi;
   function SmartsHi (target in BLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
      context_id binary_integer := 0;
   begin
      if indexctx.IndexInfo is not null then
         context_id := BingoPackage.getContextID(indexctx.IndexInfo);
      end if;
      return SmartsHi_blob(context_id, target, query);
   end SmartsHi;

   function Exact (target in VARCHAR2, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
            scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Exact(to_clob(target), to_clob(query), null, indexctx, scanctx, scanflg);
   end Exact;
   function Exact (target in VARCHAR2, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
            scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Exact(to_clob(target), to_clob(query), params, indexctx, scanctx, scanflg);
   end Exact;
   function Exact (target in VARCHAR2, query in CLOB, indexctx IN sys.ODCIIndexCtx,
            scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Exact(to_clob(target), query, null, indexctx, scanctx, scanflg);
   end Exact;
   function Exact (target in VARCHAR2, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
            scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Exact(to_clob(target), query, params, indexctx, scanctx, scanflg);
   end Exact;
   function Exact (target in CLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
            scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Exact(target, to_clob(query), null, indexctx, scanctx, scanflg);
   end Exact;
   function Exact (target in CLOB, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
            scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Exact(target, to_clob(query), params, indexctx, scanctx, scanflg);
   end Exact;
   function Exact (target in CLOB, query in CLOB, indexctx IN sys.ODCIIndexCtx,
            scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Exact(target, query, null, indexctx, scanctx, scanflg);
   end Exact;
   function Exact (target in CLOB, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
      context_id binary_integer := 0;
   begin
      if indexctx.IndexInfo is not null then
         context_id := BingoPackage.getContextID(indexctx.IndexInfo);
      end if;
      return Exact_clob(context_id, target, query, params);
   end Exact;
   function Exact (target in BLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Exact(target, to_clob(query), null, indexctx, scanctx, scanflg);
   end Exact;
   function Exact (target in BLOB, query in VARCHAR2, params in VARCHAR2,
            indexctx IN sys.ODCIIndexCtx, scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Exact(target, to_clob(query), params, indexctx, scanctx, scanflg);
   end Exact;
   function Exact (target in BLOB, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Exact(target, query, null, indexctx, scanctx, scanflg);
   end Exact;
   function Exact (target in BLOB, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
            scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
      context_id binary_integer := 0;
   begin
      if indexctx.IndexInfo is not null then
         context_id := BingoPackage.getContextID(indexctx.IndexInfo);
      end if;
      return Exact_blob(context_id, target, query, params);
   end Exact;

   function ExactHi (target in VARCHAR2, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
   begin
      return ExactHi(to_clob(target), to_clob(query), null, indexctx, scanctx, scanflg);
   end ExactHi;
   function ExactHi (target in VARCHAR2, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
   begin
      return ExactHi(to_clob(target), to_clob(query), params, indexctx, scanctx, scanflg);
   end ExactHi;
   function ExactHi (target in VARCHAR2, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
   begin
      return ExactHi(to_clob(target), query, null, indexctx, scanctx, scanflg);
   end ExactHi;
   function ExactHi (target in VARCHAR2, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
   begin
      return ExactHi(to_clob(target), query, params, indexctx, scanctx, scanflg);
   end ExactHi;

   function ExactHi (target in CLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
   begin
      return ExactHi(target, to_clob(query), null, indexctx, scanctx, scanflg);
   end ExactHi;
   function ExactHi (target in CLOB, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
   begin
      return ExactHi(target, to_clob(query), params, indexctx, scanctx, scanflg);
   end ExactHi;
   function ExactHi (target in CLOB, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
   begin
      return ExactHi(target, query, null, indexctx, scanctx, scanflg);
   end ExactHi;
   function ExactHi (target in CLOB, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
      context_id binary_integer := 0;
   begin
      if indexctx.IndexInfo is not null then
         context_id := BingoPackage.getContextID(indexctx.IndexInfo);
      end if;
      return ExactHi_clob(context_id, target, query, params);
   end ExactHi;
   function ExactHi (target in BLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
   begin
      return ExactHi(target, to_clob(query), null, indexctx, scanctx, scanflg);
   end ExactHi;
   function ExactHi (target in BLOB, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
   begin
      return ExactHi(target, to_clob(query), params, indexctx, scanctx, scanflg);
   end ExactHi;
   function ExactHi (target in BLOB, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
   begin
      return ExactHi(target, query, null, indexctx, scanctx, scanflg);
   end ExactHi;
   function ExactHi (target in BLOB, query in CLOB, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return CLOB IS
      context_id binary_integer := 0;
   begin
      if indexctx.IndexInfo is not null then
         context_id := BingoPackage.getContextID(indexctx.IndexInfo);
      end if;
      return ExactHi_blob(context_id, target, query, params);
   end ExactHi;

   function Sim (target in VARCHAR2, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Sim(to_clob(target), to_clob(query), null, indexctx, scanctx, scanflg);
   end Sim;
   function Sim (target in VARCHAR2, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Sim(to_clob(target), to_clob(query), params, indexctx, scanctx, scanflg);
   end Sim;
   function Sim (target in VARCHAR2, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Sim(to_clob(target), query, null, indexctx, scanctx, scanflg);
   end Sim;
   function Sim (target in VARCHAR2, query in CLOB, params VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Sim(to_clob(target), query, params, indexctx, scanctx, scanflg);
   end Sim;
   function Sim (target in CLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Sim(target, to_clob(query), null, indexctx, scanctx, scanflg);
   end Sim;
   function Sim (target in CLOB, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Sim(target, to_clob(query), params, indexctx, scanctx, scanflg);
   end Sim;
   function Sim (target in CLOB, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Sim(target, query, null, indexctx, scanctx, scanflg);
   end Sim;
   function Sim (target in CLOB, query in CLOB, params VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
      context_id binary_integer := 0;
   begin
      if indexctx.IndexInfo is not null then
         context_id := BingoPackage.getContextID(indexctx.IndexInfo);
      end if;
      return Sim_clob(context_id, target, query, params);
   end Sim;
   function Sim (target in BLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Sim(target, to_clob(query), null, indexctx, scanctx, scanflg);
   end Sim;
   function Sim (target in BLOB, query in VARCHAR2, params in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Sim(target, to_clob(query), params, indexctx, scanctx, scanflg);
   end Sim;
   function Sim (target in BLOB, query in CLOB, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
   begin
      return Sim(target, query, null, indexctx, scanctx, scanflg);
   end Sim;
   function Sim (target in BLOB, query in CLOB, params VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                 scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER IS
      context_id binary_integer := 0;
   begin
      if indexctx.IndexInfo is not null then
         context_id := BingoPackage.getContextID(indexctx.IndexInfo);
      end if;
      return Sim_blob(context_id, target, query, params);
   end Sim;

   function GrossCalc (target in VARCHAR2) return VARCHAR2 IS
   begin
      return GrossCalc(to_clob(target));
   end GrossCalc;
   function GrossCalc (target in CLOB) return VARCHAR2 IS
   begin
      return GrossCalc_clob(target);
   end GrossCalc;
   function GrossCalc (target in BLOB) return VARCHAR2 IS
   begin
      return GrossCalc_blob(target);
   end GrossCalc;

   function Gross (target in VARCHAR2, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                   scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER is
   begin
      return Gross(to_clob(target), query, indexctx, scanctx, scanflg);
   end Gross;
   function Gross (target in CLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                   scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER is
      context_id binary_integer := 0;
   begin
      if indexctx.IndexInfo is not null then
         context_id := BingoPackage.getContextID(indexctx.IndexInfo);
      end if;
      return Gross_clob(context_id, target, query);
   end Gross;
   function Gross (target in BLOB, query in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                   scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER is
      context_id binary_integer := 0;
   begin
      if indexctx.IndexInfo is not null then
         context_id := BingoPackage.getContextID(indexctx.IndexInfo);
      end if;
      return Gross_blob(context_id, target, query);
   end Gross;

   function Mass (target in VARCHAR2, indexctx IN sys.ODCIIndexCtx,
                   scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER is
   begin
      return Mass(to_clob(target), indexctx, scanctx, scanflg);
   end Mass;
   function Mass (target in CLOB, indexctx IN sys.ODCIIndexCtx,
                   scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER is
      context_id binary_integer := 0;
   begin
      if indexctx.IndexInfo is not null then
         context_id := BingoPackage.getContextID(indexctx.IndexInfo);
      end if;
      return Mass_clob(context_id, target, NULL);
   end Mass;
   function Mass (target in BLOB, indexctx IN sys.ODCIIndexCtx,
                  scanctx in out MangoIndex, scanflg IN NUMBER) return NUMBER is
      context_id binary_integer := 0;
   begin
      if indexctx.IndexInfo is not null then
         context_id := BingoPackage.getContextID(indexctx.IndexInfo);
      end if;
      return Mass_blob(context_id, target, NULL);
   end Mass;

   function Mass (target in VARCHAR2, typee in VARCHAR2) return NUMBER is
   begin
      return Mass(to_clob(target), typee);
   end Mass;
   function Mass (target in CLOB, typee in VARCHAR2) return NUMBER is
   begin
      return Mass_clob(0, target, typee);
   end Mass;
   function Mass (target in BLOB, typee in VARCHAR2) return NUMBER is
   begin
      return Mass_blob(0, target, typee);
   end Mass;

   function Molfile (target in VARCHAR2) return CLOB is
   begin
      return Molfile_clob(to_clob(target), NULL);
   end Molfile;
   function Molfile (target in CLOB) return CLOB is
   begin
      return Molfile_clob(target, NULL);
   end Molfile;
   function Molfile (target in BLOB) return CLOB is
   begin
      return Molfile_blob(target, NULL);
   end Molfile;
   function Molfile (target in VARCHAR2, options in VARCHAR2) return CLOB is
   begin
      return Molfile_clob(to_clob(target), options);
   end Molfile;
   function Molfile (target in CLOB, options in VARCHAR2) return CLOB is
   begin
      return Molfile_clob(target, options);
   end Molfile;
   function Molfile (target in BLOB, options in VARCHAR2) return CLOB is
   begin
      return Molfile_blob(target, options);
   end Molfile;

   function CML (target in VARCHAR2) return CLOB is
   begin
      return CML_clob(to_clob(target));
   end CML;
   function CML (target in CLOB) return CLOB is
   begin
      return CML_clob(target);
   end CML;
   function CML (target in BLOB) return CLOB is
   begin
      return CML_blob(target);
   end CML;

   function SMILES (target in VARCHAR2) return VARCHAR2 is
   begin
      return SMILES_clob(to_clob(target), NULL);
   end SMILES;
   function SMILES (target in CLOB) return VARCHAR2 is
   begin
      return SMILES_clob(target, NULL);
   end SMILES;
   function SMILES (target in BLOB) return VARCHAR2 is
   begin
      return SMILES_blob(target, NULL);
   end SMILES;
   function SMILES (target in VARCHAR2, options in VARCHAR2) return VARCHAR2 is
   begin
      return SMILES_clob(to_clob(target), options);
   end SMILES;
   function SMILES (target in CLOB, options in VARCHAR2) return VARCHAR2 is
   begin
      return SMILES_clob(target, options);
   end SMILES;
   function SMILES (target in BLOB, options in VARCHAR2) return VARCHAR2 is
   begin
      return SMILES_blob(target, options);
   end SMILES;

   function InChI (target in VARCHAR2, options in VARCHAR2) return CLOB is
   begin
      return InChI_clob(to_clob(target), options);
   end InChI;
   function InChI (target in CLOB, options in VARCHAR2) return CLOB is
   begin
      return InChI_clob(target, options);
   end InChI;
   function InChI (target in BLOB, options in VARCHAR2) return CLOB is
   begin
      return InChI_blob(target, options);
   end InChI;
   
   function InChIKey (inchi in VARCHAR2) return VARCHAR2 is
   begin
      return InChIKey_clob(to_clob(inchi));
   end InChIKey;
   function InChIKey (inchi in CLOB) return VARCHAR2 is
   begin
      return InChIKey_clob(inchi);
   end InChIKey;   

   function Fingerprint (target in VARCHAR2, options in VARCHAR2) return BLOB is
   begin
      return Fingerprint_clob(to_clob(target), options);
   end Fingerprint;
   function Fingerprint (target in CLOB, options in VARCHAR2) return BLOB is
   begin
      return Fingerprint_clob(target, options);
   end Fingerprint;
   function Fingerprint (target in BLOB, options in VARCHAR2) return BLOB is
   begin
      return Fingerprint_blob(target, options);
   end Fingerprint;

   function CANSMILES (target in VARCHAR2) return VARCHAR2 is
   begin
      return CANSMILES_clob(to_clob(target));
   end CANSMILES;
   function CANSMILES (target in CLOB) return VARCHAR2 is
   begin
      return CANSMILES_clob(target);
   end CANSMILES;
   function CANSMILES (target in BLOB) return VARCHAR2 is
   begin
      return CANSMILES_blob(target);
   end CANSMILES;

END MangoPackage;
/
-- necessary for Oracle 9 on Solaris
grant execute on mangopackage to public;
spool off;
